/*
 * MIB Registers
 */
struct bcm_mib {
	u_int32_t tx_good_octets;
	u_int32_t tx_good_pkts;
	u_int32_t tx_octets;
	u_int32_t tx_pkts;
	u_int32_t tx_broadcast_pkts;
	u_int32_t tx_multicast_pkts;
	u_int32_t tx_len_64;
	u_int32_t tx_len_65_to_127;
	u_int32_t tx_len_128_to_255;
	u_int32_t tx_len_256_to_511;
	u_int32_t tx_len_512_to_1023;
	u_int32_t tx_len_1024_to_max;
	u_int32_t tx_jabber_pkts;
	u_int32_t tx_oversize_pkts;
	u_int32_t tx_fragment_pkts;
	u_int32_t tx_underruns;
	u_int32_t tx_total_cols;
	u_int32_t tx_single_cols;
	u_int32_t tx_multiple_cols;
	u_int32_t tx_excessive_cols;
	u_int32_t tx_late_cols;
	u_int32_t tx_defered;
	u_int32_t tx_carrier_lost;
	u_int32_t tx_pause_pkts;
	u_int32_t pad[8];

	u_int32_t rx_good_octets;
	u_int32_t rx_good_pkts;
	u_int32_t rx_octets;
	u_int32_t rx_pkts;
	u_int32_t rx_broadcast_pkts;
	u_int32_t rx_multicast_pkts;
	u_int32_t rx_len_64;
	u_int32_t rx_len_65_to_127;
	u_int32_t rx_len_128_to_255;
	u_int32_t rx_len_256_to_511;
	u_int32_t rx_len_512_to_1023;
	u_int32_t rx_len_1024_to_max;
	u_int32_t rx_jabber_pkts;
	u_int32_t rx_oversize_pkts;
	u_int32_t rx_fragment_pkts;
	u_int32_t rx_missed_pkts;
	u_int32_t rx_crc_align_errs;
	u_int32_t rx_undersize;
	u_int32_t rx_crc_errs;
	u_int32_t rx_align_errs;
	u_int32_t rx_symbol_errs;
	u_int32_t rx_pause_pkts;
	u_int32_t rx_nonpause_pkts;
};

#define SIOCGBCMSTATS _IOWR('i', 205, struct ifreq)
